// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Topic Space operation.
 */
@Fluent
public final class TopicSpacesListResult implements JsonSerializable<TopicSpacesListResult> {
    /*
     * A collection of Topic Space.
     */
    private List<TopicSpaceInner> value;

    /*
     * A link for the next page of Topic Space.
     */
    private String nextLink;

    /**
     * Creates an instance of TopicSpacesListResult class.
     */
    public TopicSpacesListResult() {
    }

    /**
     * Get the value property: A collection of Topic Space.
     * 
     * @return the value value.
     */
    public List<TopicSpaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Topic Space.
     * 
     * @param value the value value to set.
     * @return the TopicSpacesListResult object itself.
     */
    public TopicSpacesListResult withValue(List<TopicSpaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of Topic Space.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of Topic Space.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TopicSpacesListResult object itself.
     */
    public TopicSpacesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicSpacesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicSpacesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicSpacesListResult.
     */
    public static TopicSpacesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicSpacesListResult deserializedTopicSpacesListResult = new TopicSpacesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TopicSpaceInner> value = reader.readArray(reader1 -> TopicSpaceInner.fromJson(reader1));
                    deserializedTopicSpacesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTopicSpacesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicSpacesListResult;
        });
    }
}
