// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TopicTypeAdditionalEnforcedPermission model.
 */
@Fluent
public final class TopicTypeAdditionalEnforcedPermission
    implements JsonSerializable<TopicTypeAdditionalEnforcedPermission> {
    /*
     * The permissionName property.
     */
    private String permissionName;

    /*
     * The isDataAction property.
     */
    private Boolean isDataAction;

    /**
     * Creates an instance of TopicTypeAdditionalEnforcedPermission class.
     */
    public TopicTypeAdditionalEnforcedPermission() {
    }

    /**
     * Get the permissionName property: The permissionName property.
     * 
     * @return the permissionName value.
     */
    public String permissionName() {
        return this.permissionName;
    }

    /**
     * Set the permissionName property: The permissionName property.
     * 
     * @param permissionName the permissionName value to set.
     * @return the TopicTypeAdditionalEnforcedPermission object itself.
     */
    public TopicTypeAdditionalEnforcedPermission withPermissionName(String permissionName) {
        this.permissionName = permissionName;
        return this;
    }

    /**
     * Get the isDataAction property: The isDataAction property.
     * 
     * @return the isDataAction value.
     */
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    /**
     * Set the isDataAction property: The isDataAction property.
     * 
     * @param isDataAction the isDataAction value to set.
     * @return the TopicTypeAdditionalEnforcedPermission object itself.
     */
    public TopicTypeAdditionalEnforcedPermission withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissionName", this.permissionName);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicTypeAdditionalEnforcedPermission from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicTypeAdditionalEnforcedPermission if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicTypeAdditionalEnforcedPermission.
     */
    public static TopicTypeAdditionalEnforcedPermission fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicTypeAdditionalEnforcedPermission deserializedTopicTypeAdditionalEnforcedPermission
                = new TopicTypeAdditionalEnforcedPermission();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("permissionName".equals(fieldName)) {
                    deserializedTopicTypeAdditionalEnforcedPermission.permissionName = reader.getString();
                } else if ("isDataAction".equals(fieldName)) {
                    deserializedTopicTypeAdditionalEnforcedPermission.isDataAction
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicTypeAdditionalEnforcedPermission;
        });
    }
}
