// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicTypeInfoInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Topic Types operation.
 */
@Fluent
public final class TopicTypesListResult implements JsonSerializable<TopicTypesListResult> {
    /*
     * A collection of topic types
     */
    private List<TopicTypeInfoInner> value;

    /**
     * Creates an instance of TopicTypesListResult class.
     */
    public TopicTypesListResult() {
    }

    /**
     * Get the value property: A collection of topic types.
     * 
     * @return the value value.
     */
    public List<TopicTypeInfoInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of topic types.
     * 
     * @param value the value value to set.
     * @return the TopicTypesListResult object itself.
     */
    public TopicTypesListResult withValue(List<TopicTypeInfoInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicTypesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicTypesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicTypesListResult.
     */
    public static TopicTypesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicTypesListResult deserializedTopicTypesListResult = new TopicTypesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TopicTypeInfoInner> value = reader.readArray(reader1 -> TopicTypeInfoInner.fromJson(reader1));
                    deserializedTopicTypesListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicTypesListResult;
        });
    }
}
