// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List Topics operation.
 */
@Fluent
public final class TopicsListResult implements JsonSerializable<TopicsListResult> {
    /*
     * A collection of Topics
     */
    private List<TopicInner> value;

    /*
     * A link for the next page of topics
     */
    private String nextLink;

    /**
     * Creates an instance of TopicsListResult class.
     */
    public TopicsListResult() {
    }

    /**
     * Get the value property: A collection of Topics.
     * 
     * @return the value value.
     */
    public List<TopicInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of Topics.
     * 
     * @param value the value value to set.
     * @return the TopicsListResult object itself.
     */
    public TopicsListResult withValue(List<TopicInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of topics.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of topics.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TopicsListResult object itself.
     */
    public TopicsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicsListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicsListResult.
     */
    public static TopicsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicsListResult deserializedTopicsListResult = new TopicsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TopicInner> value = reader.readArray(reader1 -> TopicInner.fromJson(reader1));
                    deserializedTopicsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTopicsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicsListResult;
        });
    }
}
