// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the topic spaces configuration info of a namespace.
 */
@Fluent
public final class UpdateTopicSpacesConfigurationInfo implements JsonSerializable<UpdateTopicSpacesConfigurationInfo> {
    /*
     * Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     */
    private TopicSpacesConfigurationState state;

    /*
     * This property is used to specify custom topic to which events will be routed to from topic spaces configuration
     * under namespace.
     */
    private String routeTopicResourceId;

    /*
     * Routing enrichments for topic spaces configuration.
     */
    private RoutingEnrichments routingEnrichments;

    /*
     * The maximum session expiry in hours. The property default value is 1 hour.
     * Min allowed value is 1 hour and max allowed value is 8 hours.
     */
    private Integer maximumSessionExpiryInHours;

    /*
     * The maximum number of sessions per authentication name. The property default value is 1.
     * Min allowed value is 1 and max allowed value is 100.
     */
    private Integer maximumClientSessionsPerAuthenticationName;

    /*
     * Routing identity info for topic spaces configuration.
     */
    private RoutingIdentityInfo routingIdentityInfo;

    /*
     * Custom domain info for topic spaces configuration.
     */
    private List<CustomDomainConfiguration> customDomains;

    /**
     * Creates an instance of UpdateTopicSpacesConfigurationInfo class.
     */
    public UpdateTopicSpacesConfigurationInfo() {
    }

    /**
     * Get the state property: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     * 
     * @return the state value.
     */
    public TopicSpacesConfigurationState state() {
        return this.state;
    }

    /**
     * Set the state property: Indicate if Topic Spaces Configuration is enabled for the namespace. Default is Disabled.
     * 
     * @param state the state value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withState(TopicSpacesConfigurationState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the routeTopicResourceId property: This property is used to specify custom topic to which events will be
     * routed to from topic spaces configuration under namespace.
     * 
     * @return the routeTopicResourceId value.
     */
    public String routeTopicResourceId() {
        return this.routeTopicResourceId;
    }

    /**
     * Set the routeTopicResourceId property: This property is used to specify custom topic to which events will be
     * routed to from topic spaces configuration under namespace.
     * 
     * @param routeTopicResourceId the routeTopicResourceId value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withRouteTopicResourceId(String routeTopicResourceId) {
        this.routeTopicResourceId = routeTopicResourceId;
        return this;
    }

    /**
     * Get the routingEnrichments property: Routing enrichments for topic spaces configuration.
     * 
     * @return the routingEnrichments value.
     */
    public RoutingEnrichments routingEnrichments() {
        return this.routingEnrichments;
    }

    /**
     * Set the routingEnrichments property: Routing enrichments for topic spaces configuration.
     * 
     * @param routingEnrichments the routingEnrichments value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withRoutingEnrichments(RoutingEnrichments routingEnrichments) {
        this.routingEnrichments = routingEnrichments;
        return this;
    }

    /**
     * Get the maximumSessionExpiryInHours property: The maximum session expiry in hours. The property default value is
     * 1 hour.
     * Min allowed value is 1 hour and max allowed value is 8 hours.
     * 
     * @return the maximumSessionExpiryInHours value.
     */
    public Integer maximumSessionExpiryInHours() {
        return this.maximumSessionExpiryInHours;
    }

    /**
     * Set the maximumSessionExpiryInHours property: The maximum session expiry in hours. The property default value is
     * 1 hour.
     * Min allowed value is 1 hour and max allowed value is 8 hours.
     * 
     * @param maximumSessionExpiryInHours the maximumSessionExpiryInHours value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withMaximumSessionExpiryInHours(Integer maximumSessionExpiryInHours) {
        this.maximumSessionExpiryInHours = maximumSessionExpiryInHours;
        return this;
    }

    /**
     * Get the maximumClientSessionsPerAuthenticationName property: The maximum number of sessions per authentication
     * name. The property default value is 1.
     * Min allowed value is 1 and max allowed value is 100.
     * 
     * @return the maximumClientSessionsPerAuthenticationName value.
     */
    public Integer maximumClientSessionsPerAuthenticationName() {
        return this.maximumClientSessionsPerAuthenticationName;
    }

    /**
     * Set the maximumClientSessionsPerAuthenticationName property: The maximum number of sessions per authentication
     * name. The property default value is 1.
     * Min allowed value is 1 and max allowed value is 100.
     * 
     * @param maximumClientSessionsPerAuthenticationName the maximumClientSessionsPerAuthenticationName value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo
        withMaximumClientSessionsPerAuthenticationName(Integer maximumClientSessionsPerAuthenticationName) {
        this.maximumClientSessionsPerAuthenticationName = maximumClientSessionsPerAuthenticationName;
        return this;
    }

    /**
     * Get the routingIdentityInfo property: Routing identity info for topic spaces configuration.
     * 
     * @return the routingIdentityInfo value.
     */
    public RoutingIdentityInfo routingIdentityInfo() {
        return this.routingIdentityInfo;
    }

    /**
     * Set the routingIdentityInfo property: Routing identity info for topic spaces configuration.
     * 
     * @param routingIdentityInfo the routingIdentityInfo value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withRoutingIdentityInfo(RoutingIdentityInfo routingIdentityInfo) {
        this.routingIdentityInfo = routingIdentityInfo;
        return this;
    }

    /**
     * Get the customDomains property: Custom domain info for topic spaces configuration.
     * 
     * @return the customDomains value.
     */
    public List<CustomDomainConfiguration> customDomains() {
        return this.customDomains;
    }

    /**
     * Set the customDomains property: Custom domain info for topic spaces configuration.
     * 
     * @param customDomains the customDomains value to set.
     * @return the UpdateTopicSpacesConfigurationInfo object itself.
     */
    public UpdateTopicSpacesConfigurationInfo withCustomDomains(List<CustomDomainConfiguration> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routingEnrichments() != null) {
            routingEnrichments().validate();
        }
        if (routingIdentityInfo() != null) {
            routingIdentityInfo().validate();
        }
        if (customDomains() != null) {
            customDomains().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("routeTopicResourceId", this.routeTopicResourceId);
        jsonWriter.writeJsonField("routingEnrichments", this.routingEnrichments);
        jsonWriter.writeNumberField("maximumSessionExpiryInHours", this.maximumSessionExpiryInHours);
        jsonWriter.writeNumberField("maximumClientSessionsPerAuthenticationName",
            this.maximumClientSessionsPerAuthenticationName);
        jsonWriter.writeJsonField("routingIdentityInfo", this.routingIdentityInfo);
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateTopicSpacesConfigurationInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateTopicSpacesConfigurationInfo if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateTopicSpacesConfigurationInfo.
     */
    public static UpdateTopicSpacesConfigurationInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateTopicSpacesConfigurationInfo deserializedUpdateTopicSpacesConfigurationInfo
                = new UpdateTopicSpacesConfigurationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.state
                        = TopicSpacesConfigurationState.fromString(reader.getString());
                } else if ("routeTopicResourceId".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routeTopicResourceId = reader.getString();
                } else if ("routingEnrichments".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routingEnrichments
                        = RoutingEnrichments.fromJson(reader);
                } else if ("maximumSessionExpiryInHours".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.maximumSessionExpiryInHours
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maximumClientSessionsPerAuthenticationName".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.maximumClientSessionsPerAuthenticationName
                        = reader.getNullable(JsonReader::getInt);
                } else if ("routingIdentityInfo".equals(fieldName)) {
                    deserializedUpdateTopicSpacesConfigurationInfo.routingIdentityInfo
                        = RoutingIdentityInfo.fromJson(reader);
                } else if ("customDomains".equals(fieldName)) {
                    List<CustomDomainConfiguration> customDomains
                        = reader.readArray(reader1 -> CustomDomainConfiguration.fromJson(reader1));
                    deserializedUpdateTopicSpacesConfigurationInfo.customDomains = customDomains;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpdateTopicSpacesConfigurationInfo;
        });
    }
}
