// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.VerifiedPartnerInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List verified partners operation.
 */
@Fluent
public final class VerifiedPartnersListResult implements JsonSerializable<VerifiedPartnersListResult> {
    /*
     * A collection of verified partners.
     */
    private List<VerifiedPartnerInner> value;

    /*
     * A link for the next page of verified partners if any.
     */
    private String nextLink;

    /**
     * Creates an instance of VerifiedPartnersListResult class.
     */
    public VerifiedPartnersListResult() {
    }

    /**
     * Get the value property: A collection of verified partners.
     * 
     * @return the value value.
     */
    public List<VerifiedPartnerInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of verified partners.
     * 
     * @param value the value value to set.
     * @return the VerifiedPartnersListResult object itself.
     */
    public VerifiedPartnersListResult withValue(List<VerifiedPartnerInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of verified partners if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of verified partners if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VerifiedPartnersListResult object itself.
     */
    public VerifiedPartnersListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VerifiedPartnersListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VerifiedPartnersListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VerifiedPartnersListResult.
     */
    public static VerifiedPartnersListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VerifiedPartnersListResult deserializedVerifiedPartnersListResult = new VerifiedPartnersListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VerifiedPartnerInner> value
                        = reader.readArray(reader1 -> VerifiedPartnerInner.fromJson(reader1));
                    deserializedVerifiedPartnersListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVerifiedPartnersListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVerifiedPartnersListResult;
        });
    }
}
