/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CaCertificateProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CaCertificateProperties
implements JsonSerializable<CaCertificateProperties> {
    private String description;
    private String encodedCertificate;
    private OffsetDateTime issueTimeInUtc;
    private OffsetDateTime expiryTimeInUtc;
    private CaCertificateProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public CaCertificateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    public CaCertificateProperties withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    public OffsetDateTime issueTimeInUtc() {
        return this.issueTimeInUtc;
    }

    public OffsetDateTime expiryTimeInUtc() {
        return this.expiryTimeInUtc;
    }

    public CaCertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        return jsonWriter.writeEndObject();
    }

    public static CaCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CaCertificateProperties)jsonReader.readObject(reader -> {
            CaCertificateProperties deserializedCaCertificateProperties = new CaCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedCaCertificateProperties.description = reader.getString();
                    continue;
                }
                if ("encodedCertificate".equals(fieldName)) {
                    deserializedCaCertificateProperties.encodedCertificate = reader.getString();
                    continue;
                }
                if ("issueTimeInUtc".equals(fieldName)) {
                    deserializedCaCertificateProperties.issueTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiryTimeInUtc".equals(fieldName)) {
                    deserializedCaCertificateProperties.expiryTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCaCertificateProperties.provisioningState = CaCertificateProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCaCertificateProperties;
        });
    }
}

