/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientProperties;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.io.IOException;
import java.util.Map;

public final class ClientInner
extends ProxyResource {
    private ClientProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ClientProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ClientInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String authenticationName() {
        return this.innerProperties() == null ? null : this.innerProperties().authenticationName();
    }

    public ClientInner withAuthenticationName(String authenticationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withAuthenticationName(authenticationName);
        return this;
    }

    public ClientCertificateAuthentication clientCertificateAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertificateAuthentication();
    }

    public ClientInner withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withClientCertificateAuthentication(clientCertificateAuthentication);
        return this;
    }

    public ClientState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ClientInner withState(ClientState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Map<String, Object> attributes() {
        return this.innerProperties() == null ? null : this.innerProperties().attributes();
    }

    public ClientInner withAttributes(Map<String, Object> attributes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withAttributes(attributes);
        return this;
    }

    public ClientProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClientInner fromJson(JsonReader jsonReader) throws IOException {
        return (ClientInner)((Object)jsonReader.readObject(reader -> {
            ClientInner deserializedClientInner = new ClientInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClientInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedClientInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedClientInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedClientInner.innerProperties = ClientProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedClientInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientInner;
        }));
    }
}

