/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceTopicProperties;
import com.azure.resourcemanager.eventgrid.models.EventInputSchema;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublisherType;
import java.io.IOException;

public final class NamespaceTopicInner
extends ProxyResource {
    private NamespaceTopicProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private NamespaceTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public NamespaceTopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PublisherType publisherType() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherType();
    }

    public NamespaceTopicInner withPublisherType(PublisherType publisherType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withPublisherType(publisherType);
        return this;
    }

    public EventInputSchema inputSchema() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchema();
    }

    public NamespaceTopicInner withInputSchema(EventInputSchema inputSchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withInputSchema(inputSchema);
        return this;
    }

    public Integer eventRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().eventRetentionInDays();
    }

    public NamespaceTopicInner withEventRetentionInDays(Integer eventRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withEventRetentionInDays(eventRetentionInDays);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NamespaceTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (NamespaceTopicInner)((Object)jsonReader.readObject(reader -> {
            NamespaceTopicInner deserializedNamespaceTopicInner = new NamespaceTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNamespaceTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNamespaceTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNamespaceTopicInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNamespaceTopicInner.innerProperties = NamespaceTopicProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNamespaceTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespaceTopicInner;
        }));
    }
}

