/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerAuthorization;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class PartnerConfigurationInner
extends ProxyResource {
    private PartnerConfigurationProperties innerProperties;
    private SystemData systemData;
    private String location;
    private Map<String, String> tags;
    private String type;
    private String name;
    private String id;

    private PartnerConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public PartnerConfigurationInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public PartnerConfigurationInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PartnerAuthorization partnerAuthorization() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerAuthorization();
    }

    public PartnerConfigurationInner withPartnerAuthorization(PartnerAuthorization partnerAuthorization) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationProperties();
        }
        this.innerProperties().withPartnerAuthorization(partnerAuthorization);
        return this;
    }

    public PartnerConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PartnerConfigurationInner withProvisioningState(PartnerConfigurationProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PartnerConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerConfigurationInner)((Object)jsonReader.readObject(reader -> {
            PartnerConfigurationInner deserializedPartnerConfigurationInner = new PartnerConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.innerProperties = PartnerConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPartnerConfigurationInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerConfigurationInner;
        }));
    }
}

