/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerRegistrationProperties;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationProvisioningState;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class PartnerRegistrationInner
extends Resource {
    private PartnerRegistrationProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private PartnerRegistrationProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PartnerRegistrationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PartnerRegistrationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public PartnerRegistrationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    public PartnerRegistrationInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerRegistrationProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PartnerRegistrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerRegistrationInner)((Object)jsonReader.readObject(reader -> {
            PartnerRegistrationInner deserializedPartnerRegistrationInner = new PartnerRegistrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerRegistrationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.innerProperties = PartnerRegistrationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerRegistrationInner;
        }));
    }
}

