/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class PartnerTopicProperties
implements JsonSerializable<PartnerTopicProperties> {
    private UUID partnerRegistrationImmutableId;
    private String source;
    private EventTypeInfo eventTypeInfo;
    private OffsetDateTime expirationTimeIfNotActivatedUtc;
    private PartnerTopicProvisioningState provisioningState;
    private PartnerTopicActivationState activationState;
    private String partnerTopicFriendlyDescription;
    private String messageForActivation;

    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    public PartnerTopicProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PartnerTopicProperties withSource(String source) {
        this.source = source;
        return this;
    }

    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    public PartnerTopicProperties withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    public PartnerTopicProperties withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    public PartnerTopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PartnerTopicActivationState activationState() {
        return this.activationState;
    }

    public PartnerTopicProperties withActivationState(PartnerTopicActivationState activationState) {
        this.activationState = activationState;
        return this;
    }

    public String partnerTopicFriendlyDescription() {
        return this.partnerTopicFriendlyDescription;
    }

    public PartnerTopicProperties withPartnerTopicFriendlyDescription(String partnerTopicFriendlyDescription) {
        this.partnerTopicFriendlyDescription = partnerTopicFriendlyDescription;
        return this;
    }

    public String messageForActivation() {
        return this.messageForActivation;
    }

    public PartnerTopicProperties withMessageForActivation(String messageForActivation) {
        this.messageForActivation = messageForActivation;
        return this;
    }

    public void validate() {
        if (this.eventTypeInfo() != null) {
            this.eventTypeInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId", Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeJsonField("eventTypeInfo", (JsonSerializable)this.eventTypeInfo);
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc", this.expirationTimeIfNotActivatedUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        jsonWriter.writeStringField("activationState", this.activationState == null ? null : this.activationState.toString());
        jsonWriter.writeStringField("partnerTopicFriendlyDescription", this.partnerTopicFriendlyDescription);
        jsonWriter.writeStringField("messageForActivation", this.messageForActivation);
        return jsonWriter.writeEndObject();
    }

    public static PartnerTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PartnerTopicProperties)jsonReader.readObject(reader -> {
            PartnerTopicProperties deserializedPartnerTopicProperties = new PartnerTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartnerTopicProperties.partnerRegistrationImmutableId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedPartnerTopicProperties.source = reader.getString();
                    continue;
                }
                if ("eventTypeInfo".equals(fieldName)) {
                    deserializedPartnerTopicProperties.eventTypeInfo = EventTypeInfo.fromJson(reader);
                    continue;
                }
                if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedPartnerTopicProperties.expirationTimeIfNotActivatedUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerTopicProperties.provisioningState = PartnerTopicProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("activationState".equals(fieldName)) {
                    deserializedPartnerTopicProperties.activationState = PartnerTopicActivationState.fromString(reader.getString());
                    continue;
                }
                if ("partnerTopicFriendlyDescription".equals(fieldName)) {
                    deserializedPartnerTopicProperties.partnerTopicFriendlyDescription = reader.getString();
                    continue;
                }
                if ("messageForActivation".equals(fieldName)) {
                    deserializedPartnerTopicProperties.messageForActivation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPartnerTopicProperties;
        });
    }
}

