/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PermissionBindingProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PermissionType;
import java.io.IOException;

public final class PermissionBindingProperties
implements JsonSerializable<PermissionBindingProperties> {
    private String description;
    private String topicSpaceName;
    private PermissionType permission;
    private String clientGroupName;
    private PermissionBindingProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public PermissionBindingProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String topicSpaceName() {
        return this.topicSpaceName;
    }

    public PermissionBindingProperties withTopicSpaceName(String topicSpaceName) {
        this.topicSpaceName = topicSpaceName;
        return this;
    }

    public PermissionType permission() {
        return this.permission;
    }

    public PermissionBindingProperties withPermission(PermissionType permission) {
        this.permission = permission;
        return this;
    }

    public String clientGroupName() {
        return this.clientGroupName;
    }

    public PermissionBindingProperties withClientGroupName(String clientGroupName) {
        this.clientGroupName = clientGroupName;
        return this;
    }

    public PermissionBindingProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("topicSpaceName", this.topicSpaceName);
        jsonWriter.writeStringField("permission", this.permission == null ? null : this.permission.toString());
        jsonWriter.writeStringField("clientGroupName", this.clientGroupName);
        return jsonWriter.writeEndObject();
    }

    public static PermissionBindingProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PermissionBindingProperties)jsonReader.readObject(reader -> {
            PermissionBindingProperties deserializedPermissionBindingProperties = new PermissionBindingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedPermissionBindingProperties.description = reader.getString();
                    continue;
                }
                if ("topicSpaceName".equals(fieldName)) {
                    deserializedPermissionBindingProperties.topicSpaceName = reader.getString();
                    continue;
                }
                if ("permission".equals(fieldName)) {
                    deserializedPermissionBindingProperties.permission = PermissionType.fromString(reader.getString());
                    continue;
                }
                if ("clientGroupName".equals(fieldName)) {
                    deserializedPermissionBindingProperties.clientGroupName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPermissionBindingProperties.provisioningState = PermissionBindingProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPermissionBindingProperties;
        });
    }
}

