/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryAttributeMapping;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

public final class WebhookEventSubscriptionDestinationProperties
implements JsonSerializable<WebhookEventSubscriptionDestinationProperties> {
    private String endpointUrl;
    private String endpointBaseUrl;
    private Integer maxEventsPerBatch;
    private Integer preferredBatchSizeInKilobytes;
    private String azureActiveDirectoryTenantId;
    private String azureActiveDirectoryApplicationIdOrUri;
    private List<DeliveryAttributeMapping> deliveryAttributeMappings;
    private TlsVersion minimumTlsVersionAllowed;

    public String endpointUrl() {
        return this.endpointUrl;
    }

    public WebhookEventSubscriptionDestinationProperties withEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    public String endpointBaseUrl() {
        return this.endpointBaseUrl;
    }

    public Integer maxEventsPerBatch() {
        return this.maxEventsPerBatch;
    }

    public WebhookEventSubscriptionDestinationProperties withMaxEventsPerBatch(Integer maxEventsPerBatch) {
        this.maxEventsPerBatch = maxEventsPerBatch;
        return this;
    }

    public Integer preferredBatchSizeInKilobytes() {
        return this.preferredBatchSizeInKilobytes;
    }

    public WebhookEventSubscriptionDestinationProperties withPreferredBatchSizeInKilobytes(Integer preferredBatchSizeInKilobytes) {
        this.preferredBatchSizeInKilobytes = preferredBatchSizeInKilobytes;
        return this;
    }

    public String azureActiveDirectoryTenantId() {
        return this.azureActiveDirectoryTenantId;
    }

    public WebhookEventSubscriptionDestinationProperties withAzureActiveDirectoryTenantId(String azureActiveDirectoryTenantId) {
        this.azureActiveDirectoryTenantId = azureActiveDirectoryTenantId;
        return this;
    }

    public String azureActiveDirectoryApplicationIdOrUri() {
        return this.azureActiveDirectoryApplicationIdOrUri;
    }

    public WebhookEventSubscriptionDestinationProperties withAzureActiveDirectoryApplicationIdOrUri(String azureActiveDirectoryApplicationIdOrUri) {
        this.azureActiveDirectoryApplicationIdOrUri = azureActiveDirectoryApplicationIdOrUri;
        return this;
    }

    public List<DeliveryAttributeMapping> deliveryAttributeMappings() {
        return this.deliveryAttributeMappings;
    }

    public WebhookEventSubscriptionDestinationProperties withDeliveryAttributeMappings(List<DeliveryAttributeMapping> deliveryAttributeMappings) {
        this.deliveryAttributeMappings = deliveryAttributeMappings;
        return this;
    }

    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    public WebhookEventSubscriptionDestinationProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    public void validate() {
        if (this.deliveryAttributeMappings() != null) {
            this.deliveryAttributeMappings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
        jsonWriter.writeNumberField("maxEventsPerBatch", (Number)this.maxEventsPerBatch);
        jsonWriter.writeNumberField("preferredBatchSizeInKilobytes", (Number)this.preferredBatchSizeInKilobytes);
        jsonWriter.writeStringField("azureActiveDirectoryTenantId", this.azureActiveDirectoryTenantId);
        jsonWriter.writeStringField("azureActiveDirectoryApplicationIdOrUri", this.azureActiveDirectoryApplicationIdOrUri);
        jsonWriter.writeArrayField("deliveryAttributeMappings", this.deliveryAttributeMappings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed", this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebhookEventSubscriptionDestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookEventSubscriptionDestinationProperties)jsonReader.readObject(reader -> {
            WebhookEventSubscriptionDestinationProperties deserializedWebhookEventSubscriptionDestinationProperties = new WebhookEventSubscriptionDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointUrl".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.endpointUrl = reader.getString();
                    continue;
                }
                if ("endpointBaseUrl".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.endpointBaseUrl = reader.getString();
                    continue;
                }
                if ("maxEventsPerBatch".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.maxEventsPerBatch = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("preferredBatchSizeInKilobytes".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.preferredBatchSizeInKilobytes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("azureActiveDirectoryTenantId".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.azureActiveDirectoryTenantId = reader.getString();
                    continue;
                }
                if ("azureActiveDirectoryApplicationIdOrUri".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.azureActiveDirectoryApplicationIdOrUri = reader.getString();
                    continue;
                }
                if ("deliveryAttributeMappings".equals(fieldName)) {
                    List deliveryAttributeMappings;
                    deserializedWebhookEventSubscriptionDestinationProperties.deliveryAttributeMappings = deliveryAttributeMappings = reader.readArray(reader1 -> DeliveryAttributeMapping.fromJson(reader1));
                    continue;
                }
                if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedWebhookEventSubscriptionDestinationProperties.minimumTlsVersionAllowed = TlsVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookEventSubscriptionDestinationProperties;
        });
    }
}

