/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.ClientGroupsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupInner;
import com.azure.resourcemanager.eventgrid.implementation.ClientGroupImpl;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.ClientGroup;
import com.azure.resourcemanager.eventgrid.models.ClientGroups;

public final class ClientGroupsImpl
implements ClientGroups {
    private static final ClientLogger LOGGER = new ClientLogger(ClientGroupsImpl.class);
    private final ClientGroupsClient innerClient;
    private final EventGridManager serviceManager;

    public ClientGroupsImpl(ClientGroupsClient innerClient, EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ClientGroup> getWithResponse(String resourceGroupName, String namespaceName, String clientGroupName, Context context) {
        Response<ClientGroupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, clientGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClientGroupImpl((ClientGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ClientGroup get(String resourceGroupName, String namespaceName, String clientGroupName) {
        ClientGroupInner inner = this.serviceClient().get(resourceGroupName, namespaceName, clientGroupName);
        if (inner != null) {
            return new ClientGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String clientGroupName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientGroupName);
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String clientGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientGroupName, context);
    }

    @Override
    public PagedIterable<ClientGroup> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<ClientGroupInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientGroupImpl((ClientGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClientGroup> listByNamespace(String resourceGroupName, String namespaceName, String filter, Integer top, Context context) {
        PagedIterable<ClientGroupInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientGroupImpl((ClientGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public ClientGroup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        return (ClientGroup)this.getWithResponse(resourceGroupName, namespaceName, clientGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<ClientGroup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientGroupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientGroupName, context);
    }

    private ClientGroupsClient serviceClient() {
        return this.innerClient;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClientGroupImpl define(String name) {
        return new ClientGroupImpl(name, this.manager());
    }
}

