/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.EventGridManager;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerRegistrationInner;
import com.azure.resourcemanager.eventgrid.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistration;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationUpdateParameters;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class PartnerRegistrationImpl
implements PartnerRegistration,
PartnerRegistration.Definition,
PartnerRegistration.Update {
    private PartnerRegistrationInner innerObject;
    private final EventGridManager serviceManager;
    private String resourceGroupName;
    private String partnerRegistrationName;
    private PartnerRegistrationUpdateParameters updatePartnerRegistrationUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public PartnerRegistrationProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public UUID partnerRegistrationImmutableId() {
        return this.innerModel().partnerRegistrationImmutableId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PartnerRegistrationInner innerModel() {
        return this.innerObject;
    }

    private EventGridManager manager() {
        return this.serviceManager;
    }

    @Override
    public PartnerRegistrationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public PartnerRegistration create() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerRegistrations().createOrUpdate(this.resourceGroupName, this.partnerRegistrationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PartnerRegistration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerRegistrations().createOrUpdate(this.resourceGroupName, this.partnerRegistrationName, this.innerModel(), context);
        return this;
    }

    PartnerRegistrationImpl(String name, EventGridManager serviceManager) {
        this.innerObject = new PartnerRegistrationInner();
        this.serviceManager = serviceManager;
        this.partnerRegistrationName = name;
    }

    @Override
    public PartnerRegistrationImpl update() {
        this.updatePartnerRegistrationUpdateParameters = new PartnerRegistrationUpdateParameters();
        return this;
    }

    @Override
    public PartnerRegistration apply() {
        this.innerObject = this.serviceManager.serviceClient().getPartnerRegistrations().update(this.resourceGroupName, this.partnerRegistrationName, this.updatePartnerRegistrationUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public PartnerRegistration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPartnerRegistrations().update(this.resourceGroupName, this.partnerRegistrationName, this.updatePartnerRegistrationUpdateParameters, context);
        return this;
    }

    PartnerRegistrationImpl(PartnerRegistrationInner innerObject, EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.partnerRegistrationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "partnerRegistrations");
    }

    @Override
    public PartnerRegistration refresh() {
        this.innerObject = (PartnerRegistrationInner)((Object)this.serviceManager.serviceClient().getPartnerRegistrations().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerRegistrationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PartnerRegistration refresh(Context context) {
        this.innerObject = (PartnerRegistrationInner)((Object)this.serviceManager.serviceClient().getPartnerRegistrations().getByResourceGroupWithResponse(this.resourceGroupName, this.partnerRegistrationName, context).getValue());
        return this;
    }

    @Override
    public PartnerRegistrationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public PartnerRegistrationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public PartnerRegistrationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updatePartnerRegistrationUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public PartnerRegistrationImpl withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.innerModel().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

