/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.AzureFunctionEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EndpointType;
import com.azure.resourcemanager.eventgrid.models.EventHubEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.HybridConnectionEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.MonitorAlertEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.ServiceBusQueueEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.ServiceBusTopicEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.StorageQueueEventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.WebhookEventSubscriptionDestination;
import java.io.IOException;

public class EventSubscriptionDestination
implements JsonSerializable<EventSubscriptionDestination> {
    private EndpointType endpointType = EndpointType.fromString("EventSubscriptionDestination");

    public EndpointType endpointType() {
        return this.endpointType;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointType", this.endpointType == null ? null : this.endpointType.toString());
        return jsonWriter.writeEndObject();
    }

    public static EventSubscriptionDestination fromJson(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionDestination)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                EventSubscriptionDestination eventSubscriptionDestination;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("endpointType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("WebHook".equals(discriminatorValue)) {
                    eventSubscriptionDestination = WebhookEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("EventHub".equals(discriminatorValue)) {
                    eventSubscriptionDestination = EventHubEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("StorageQueue".equals(discriminatorValue)) {
                    eventSubscriptionDestination = StorageQueueEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("HybridConnection".equals(discriminatorValue)) {
                    eventSubscriptionDestination = HybridConnectionEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("ServiceBusQueue".equals(discriminatorValue)) {
                    eventSubscriptionDestination = ServiceBusQueueEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("ServiceBusTopic".equals(discriminatorValue)) {
                    eventSubscriptionDestination = ServiceBusTopicEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("AzureFunction".equals(discriminatorValue)) {
                    eventSubscriptionDestination = AzureFunctionEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("MonitorAlert".equals(discriminatorValue)) {
                    eventSubscriptionDestination = MonitorAlertEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                if ("NamespaceTopic".equals(discriminatorValue)) {
                    eventSubscriptionDestination = NamespaceTopicEventSubscriptionDestination.fromJson(readerToUse.reset());
                    return eventSubscriptionDestination;
                }
                eventSubscriptionDestination = EventSubscriptionDestination.fromJsonKnownDiscriminator(readerToUse.reset());
                return eventSubscriptionDestination;
            }
        });
    }

    static EventSubscriptionDestination fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (EventSubscriptionDestination)jsonReader.readObject(reader -> {
            EventSubscriptionDestination deserializedEventSubscriptionDestination = new EventSubscriptionDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointType".equals(fieldName)) {
                    deserializedEventSubscriptionDestination.endpointType = EndpointType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventSubscriptionDestination;
        });
    }
}

