/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventDefinitionKind;
import com.azure.resourcemanager.eventgrid.models.InlineEventProperties;
import java.io.IOException;
import java.util.Map;

public final class EventTypeInfo
implements JsonSerializable<EventTypeInfo> {
    private EventDefinitionKind kind;
    private Map<String, InlineEventProperties> inlineEventTypes;

    public EventDefinitionKind kind() {
        return this.kind;
    }

    public EventTypeInfo withKind(EventDefinitionKind kind) {
        this.kind = kind;
        return this;
    }

    public Map<String, InlineEventProperties> inlineEventTypes() {
        return this.inlineEventTypes;
    }

    public EventTypeInfo withInlineEventTypes(Map<String, InlineEventProperties> inlineEventTypes) {
        this.inlineEventTypes = inlineEventTypes;
        return this;
    }

    public void validate() {
        if (this.inlineEventTypes() != null) {
            this.inlineEventTypes().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeMapField("inlineEventTypes", this.inlineEventTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EventTypeInfo fromJson(JsonReader jsonReader) throws IOException {
        return (EventTypeInfo)jsonReader.readObject(reader -> {
            EventTypeInfo deserializedEventTypeInfo = new EventTypeInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedEventTypeInfo.kind = EventDefinitionKind.fromString(reader.getString());
                    continue;
                }
                if ("inlineEventTypes".equals(fieldName)) {
                    Map inlineEventTypes;
                    deserializedEventTypeInfo.inlineEventTypes = inlineEventTypes = reader.readMap(reader1 -> InlineEventProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventTypeInfo;
        });
    }
}

