/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.IdentityType;
import com.azure.resourcemanager.eventgrid.models.UserIdentityProperties;
import java.io.IOException;
import java.util.Map;

public final class IdentityInfo
implements JsonSerializable<IdentityInfo> {
    private IdentityType type;
    private String principalId;
    private String tenantId;
    private Map<String, UserIdentityProperties> userAssignedIdentities;

    public IdentityType type() {
        return this.type;
    }

    public IdentityInfo withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public IdentityInfo withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public IdentityInfo withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public IdentityInfo withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityInfo fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityInfo)jsonReader.readObject(reader -> {
            IdentityInfo deserializedIdentityInfo = new IdentityInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIdentityInfo.type = IdentityType.fromString(reader.getString());
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedIdentityInfo.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedIdentityInfo.tenantId = reader.getString();
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedIdentityInfo.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserIdentityProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityInfo;
        });
    }
}

