/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.NamespaceInner;
import java.io.IOException;
import java.util.List;

public final class NamespacesListResult
implements JsonSerializable<NamespacesListResult> {
    private List<NamespaceInner> value;
    private String nextLink;

    public List<NamespaceInner> value() {
        return this.value;
    }

    public NamespacesListResult withValue(List<NamespaceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public NamespacesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NamespacesListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NamespacesListResult)jsonReader.readObject(reader -> {
            NamespacesListResult deserializedNamespacesListResult = new NamespacesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNamespacesListResult.value = value = reader.readArray(reader1 -> NamespaceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNamespacesListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNamespacesListResult;
        });
    }
}

