/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class NumberInFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.NUMBER_IN;
    private List<Double> values;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<Double> values() {
        return this.values;
    }

    public NumberInFilter withValues(List<Double> values) {
        this.values = values;
        return this;
    }

    @Override
    public NumberInFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static NumberInFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberInFilter)jsonReader.readObject(reader -> {
            NumberInFilter deserializedNumberInFilter = new NumberInFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberInFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberInFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedNumberInFilter.values = values = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberInFilter;
        });
    }
}

