/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;

public final class NumberLessThanFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.NUMBER_LESS_THAN;
    private Double value;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public Double value() {
        return this.value;
    }

    public NumberLessThanFilter withValue(Double value) {
        this.value = value;
        return this;
    }

    @Override
    public NumberLessThanFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeNumberField("value", (Number)this.value);
        return jsonWriter.writeEndObject();
    }

    public static NumberLessThanFilter fromJson(JsonReader jsonReader) throws IOException {
        return (NumberLessThanFilter)jsonReader.readObject(reader -> {
            NumberLessThanFilter deserializedNumberLessThanFilter = new NumberLessThanFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedNumberLessThanFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedNumberLessThanFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedNumberLessThanFilter.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNumberLessThanFilter;
        });
    }
}

