/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OperationInfo
implements JsonSerializable<OperationInfo> {
    private String provider;
    private String resource;
    private String operation;
    private String description;

    public String provider() {
        return this.provider;
    }

    public OperationInfo withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public String resource() {
        return this.resource;
    }

    public OperationInfo withResource(String resource) {
        this.resource = resource;
        return this;
    }

    public String operation() {
        return this.operation;
    }

    public OperationInfo withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public String description() {
        return this.description;
    }

    public OperationInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("resource", this.resource);
        jsonWriter.writeStringField("operation", this.operation);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static OperationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (OperationInfo)jsonReader.readObject(reader -> {
            OperationInfo deserializedOperationInfo = new OperationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provider".equals(fieldName)) {
                    deserializedOperationInfo.provider = reader.getString();
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedOperationInfo.resource = reader.getString();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedOperationInfo.operation = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOperationInfo.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationInfo;
        });
    }
}

