/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerNamespaceInner;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaceSharedAccessKeys;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicRoutingMode;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.util.List;
import java.util.Map;

public interface PartnerNamespace {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public PartnerNamespaceProvisioningState provisioningState();

    public String partnerRegistrationFullyQualifiedId();

    public TlsVersion minimumTlsVersionAllowed();

    public String endpoint();

    public PublicNetworkAccess publicNetworkAccess();

    public List<InboundIpRule> inboundIpRules();

    public Boolean disableLocalAuth();

    public PartnerTopicRoutingMode partnerTopicRoutingMode();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public PartnerNamespaceInner innerModel();

    public Update update();

    public PartnerNamespace refresh();

    public PartnerNamespace refresh(Context var1);

    public Response<PartnerNamespaceSharedAccessKeys> listSharedAccessKeysWithResponse(Context var1);

    public PartnerNamespaceSharedAccessKeys listSharedAccessKeys();

    public Response<PartnerNamespaceSharedAccessKeys> regenerateKeyWithResponse(PartnerNamespaceRegenerateKeyRequest var1, Context var2);

    public PartnerNamespaceSharedAccessKeys regenerateKey(PartnerNamespaceRegenerateKeyRequest var1);

    public static interface UpdateStages {

        public static interface WithDisableLocalAuth {
            public Update withDisableLocalAuth(Boolean var1);
        }

        public static interface WithMinimumTlsVersionAllowed {
            public Update withMinimumTlsVersionAllowed(TlsVersion var1);
        }

        public static interface WithInboundIpRules {
            public Update withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithInboundIpRules,
    UpdateStages.WithMinimumTlsVersionAllowed,
    UpdateStages.WithDisableLocalAuth {
        public PartnerNamespace apply();

        public PartnerNamespace apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPartnerTopicRoutingMode {
            public WithCreate withPartnerTopicRoutingMode(PartnerTopicRoutingMode var1);
        }

        public static interface WithDisableLocalAuth {
            public WithCreate withDisableLocalAuth(Boolean var1);
        }

        public static interface WithInboundIpRules {
            public WithCreate withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithMinimumTlsVersionAllowed {
            public WithCreate withMinimumTlsVersionAllowed(TlsVersion var1);
        }

        public static interface WithPartnerRegistrationFullyQualifiedId {
            public WithCreate withPartnerRegistrationFullyQualifiedId(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithPartnerRegistrationFullyQualifiedId,
        WithMinimumTlsVersionAllowed,
        WithPublicNetworkAccess,
        WithInboundIpRules,
        WithDisableLocalAuth,
        WithPartnerTopicRoutingMode {
            public PartnerNamespace create();

            public PartnerNamespace create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

