/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.Filter;
import com.azure.resourcemanager.eventgrid.models.FilterOperatorType;
import java.io.IOException;
import java.util.List;

public final class StringEndsWithFilter
extends Filter {
    private FilterOperatorType operatorType = FilterOperatorType.STRING_ENDS_WITH;
    private List<String> values;

    @Override
    public FilterOperatorType operatorType() {
        return this.operatorType;
    }

    public List<String> values() {
        return this.values;
    }

    public StringEndsWithFilter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public StringEndsWithFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StringEndsWithFilter fromJson(JsonReader jsonReader) throws IOException {
        return (StringEndsWithFilter)jsonReader.readObject(reader -> {
            StringEndsWithFilter deserializedStringEndsWithFilter = new StringEndsWithFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedStringEndsWithFilter.withKey(reader.getString());
                    continue;
                }
                if ("operatorType".equals(fieldName)) {
                    deserializedStringEndsWithFilter.operatorType = FilterOperatorType.fromString(reader.getString());
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedStringEndsWithFilter.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStringEndsWithFilter;
        });
    }
}

