/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicInner;
import com.azure.resourcemanager.eventgrid.models.DataResidencyBoundary;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.InputSchema;
import com.azure.resourcemanager.eventgrid.models.InputSchemaMapping;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnection;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.TopicRegenerateKeyRequest;
import com.azure.resourcemanager.eventgrid.models.TopicSharedAccessKeys;
import java.util.List;
import java.util.Map;

public interface Topic {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public IdentityInfo identity();

    public SystemData systemData();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public TopicProvisioningState provisioningState();

    public String endpoint();

    public EventTypeInfo eventTypeInfo();

    public TlsVersion minimumTlsVersionAllowed();

    public InputSchema inputSchema();

    public InputSchemaMapping inputSchemaMapping();

    public String metricResourceId();

    public PublicNetworkAccess publicNetworkAccess();

    public List<InboundIpRule> inboundIpRules();

    public Boolean disableLocalAuth();

    public DataResidencyBoundary dataResidencyBoundary();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public TopicInner innerModel();

    public Update update();

    public Topic refresh();

    public Topic refresh(Context var1);

    public Response<TopicSharedAccessKeys> listSharedAccessKeysWithResponse(Context var1);

    public TopicSharedAccessKeys listSharedAccessKeys();

    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest var1);

    public TopicSharedAccessKeys regenerateKey(TopicRegenerateKeyRequest var1, Context var2);

    public static interface UpdateStages {

        public static interface WithEventTypeInfo {
            public Update withEventTypeInfo(EventTypeInfo var1);
        }

        public static interface WithDataResidencyBoundary {
            public Update withDataResidencyBoundary(DataResidencyBoundary var1);
        }

        public static interface WithDisableLocalAuth {
            public Update withDisableLocalAuth(Boolean var1);
        }

        public static interface WithMinimumTlsVersionAllowed {
            public Update withMinimumTlsVersionAllowed(TlsVersion var1);
        }

        public static interface WithInboundIpRules {
            public Update withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(IdentityInfo var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithInboundIpRules,
    UpdateStages.WithMinimumTlsVersionAllowed,
    UpdateStages.WithDisableLocalAuth,
    UpdateStages.WithDataResidencyBoundary,
    UpdateStages.WithEventTypeInfo {
        public Topic apply();

        public Topic apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDataResidencyBoundary {
            public WithCreate withDataResidencyBoundary(DataResidencyBoundary var1);
        }

        public static interface WithDisableLocalAuth {
            public WithCreate withDisableLocalAuth(Boolean var1);
        }

        public static interface WithInboundIpRules {
            public WithCreate withInboundIpRules(List<InboundIpRule> var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithInputSchemaMapping {
            public WithCreate withInputSchemaMapping(InputSchemaMapping var1);
        }

        public static interface WithInputSchema {
            public WithCreate withInputSchema(InputSchema var1);
        }

        public static interface WithMinimumTlsVersionAllowed {
            public WithCreate withMinimumTlsVersionAllowed(TlsVersion var1);
        }

        public static interface WithEventTypeInfo {
            public WithCreate withEventTypeInfo(EventTypeInfo var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(IdentityInfo var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithEventTypeInfo,
        WithMinimumTlsVersionAllowed,
        WithInputSchema,
        WithInputSchemaMapping,
        WithPublicNetworkAccess,
        WithInboundIpRules,
        WithDisableLocalAuth,
        WithDataResidencyBoundary {
            public Topic create();

            public Topic create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

