/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventhubs.fluent.ConsumerGroupsClient;
import com.azure.resourcemanager.eventhubs.fluent.models.ConsumerGroupInner;
import com.azure.resourcemanager.eventhubs.implementation.EventHubManagementClientImpl;
import com.azure.resourcemanager.eventhubs.models.ConsumerGroupListResult;
import reactor.core.publisher.Mono;

public final class ConsumerGroupsClientImpl
implements ConsumerGroupsClient {
    private final ClientLogger logger = new ClientLogger(ConsumerGroupsClientImpl.class);
    private final ConsumerGroupsService service;
    private final EventHubManagementClientImpl client;

    ConsumerGroupsClientImpl(EventHubManagementClientImpl client) {
        this.service = (ConsumerGroupsService)RestProxy.create(ConsumerGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ConsumerGroupInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(userMetadata);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ConsumerGroupInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        ConsumerGroupInner parameters = new ConsumerGroupInner();
        parameters.withUserMetadata(userMetadata);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConsumerGroupInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ConsumerGroupInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        String userMetadata = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConsumerGroupInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ConsumerGroupInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        String userMetadata = null;
        return (ConsumerGroupInner)((Object)this.createOrUpdateAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata).block());
    }

    @Override
    public Response<ConsumerGroupInner> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, String userMetadata, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, userMetadata, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        this.deleteAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, context).block();
    }

    @Override
    public Mono<Response<ConsumerGroupInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ConsumerGroupInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (consumerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, consumerGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<ConsumerGroupInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConsumerGroupInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ConsumerGroupInner get(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName) {
        return (ConsumerGroupInner)((Object)this.getAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName).block());
    }

    @Override
    public Response<ConsumerGroupInner> getWithResponse(String resourceGroupName, String namespaceName, String eventHubName, String consumerGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, eventHubName, consumerGroupName, context).block();
    }

    private Mono<PagedResponse<ConsumerGroupInner>> listByEventHubSinglePageAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByEventHub(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsumerGroupListResult)res.getValue()).value(), ((ConsumerGroupListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ConsumerGroupInner>> listByEventHubSinglePageAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (eventHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByEventHub(this.client.getEndpoint(), resourceGroupName, namespaceName, eventHubName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsumerGroupListResult)res.getValue()).value(), ((ConsumerGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ConsumerGroupInner> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top) {
        return new PagedFlux(() -> this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top), nextLink -> this.listByEventHubNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ConsumerGroupInner> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        Integer skip = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top), nextLink -> this.listByEventHubNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ConsumerGroupInner> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listByEventHubSinglePageAsync(resourceGroupName, namespaceName, eventHubName, skip, top, context), nextLink -> this.listByEventHubNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ConsumerGroupInner> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName, Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listByEventHubAsync(resourceGroupName, namespaceName, eventHubName, skip, top, context));
    }

    @Override
    public PagedIterable<ConsumerGroupInner> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        Integer skip = null;
        Integer top = null;
        return new PagedIterable(this.listByEventHubAsync(resourceGroupName, namespaceName, eventHubName, skip, top));
    }

    private Mono<PagedResponse<ConsumerGroupInner>> listByEventHubNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByEventHubNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsumerGroupListResult)res.getValue()).value(), ((ConsumerGroupListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ConsumerGroupInner>> listByEventHubNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByEventHubNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsumerGroupListResult)res.getValue()).value(), ((ConsumerGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventHubManagementCl")
    private static interface ConsumerGroupsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsumerGroupInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="eventHubName") String var4, @PathParam(value="consumerGroupName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") ConsumerGroupInner var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="eventHubName") String var4, @PathParam(value="consumerGroupName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups/{consumerGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsumerGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="eventHubName") String var4, @PathParam(value="consumerGroupName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/consumergroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsumerGroupListResult>> listByEventHub(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="eventHubName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="$skip") Integer var7, @QueryParam(value="$top") Integer var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsumerGroupListResult>> listByEventHubNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

