/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.ConsumerGroupsClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.ConsumerGroupInner;
import com.azure.resourcemanager.eventhubs.implementation.EventHubConsumerGroupImpl;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroups;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class EventHubConsumerGroupsImpl
extends WrapperImpl<ConsumerGroupsClient>
implements EventHubConsumerGroups {
    private final EventHubsManager manager;

    public EventHubConsumerGroupsImpl(EventHubsManager manager) {
        super((Object)((EventHubManagementClient)manager.serviceClient()).getConsumerGroups());
        this.manager = manager;
    }

    public EventHubsManager manager() {
        return this.manager;
    }

    public EventHubConsumerGroupImpl define(String name) {
        return new EventHubConsumerGroupImpl(name, this.manager);
    }

    public EventHubConsumerGroup getById(String id) {
        return (EventHubConsumerGroup)this.getByIdAsync(id).block();
    }

    public Mono<EventHubConsumerGroup> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<EventHubConsumerGroup> getByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsClient)this.innerModel()).getAsync(resourceGroupName, namespaceName, eventHubName, name).map(this::wrapModel);
    }

    @Override
    public EventHubConsumerGroup getByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return (EventHubConsumerGroup)this.getByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    @Override
    public PagedIterable<EventHubConsumerGroup> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        return ((ConsumerGroupsClient)this.innerModel()).listByEventHub(resourceGroupName, namespaceName, eventHubName).mapPage(this::wrapModel);
    }

    @Override
    public PagedFlux<EventHubConsumerGroup> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return ((ConsumerGroupsClient)this.innerModel()).listByEventHubAsync(resourceGroupName, namespaceName, eventHubName).mapPage(this::wrapModel);
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Mono<Void> deleteByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsClient)this.innerModel()).deleteAsync(resourceGroupName, namespaceName, eventHubName, name);
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, eventHubName, name).block();
    }

    private EventHubConsumerGroupImpl wrapModel(ConsumerGroupInner innerModel) {
        return new EventHubConsumerGroupImpl(innerModel.name(), innerModel, this.manager);
    }
}

