// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Single item in List or Get Consumer group operation. */
@Fluent
public final class ConsumerGroupProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ConsumerGroupProperties.class);

    /*
     * Exact time the message was created.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;

    /*
     * The exact time the message was updated.
     */
    @JsonProperty(value = "updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;

    /*
     * User Metadata is a placeholder to store user-defined string data with
     * maximum length 1024. e.g. it can be used to store descriptive data, such
     * as list of teams and their contact information also user-defined
     * configuration settings can be stored.
     */
    @JsonProperty(value = "userMetadata")
    private String userMetadata;

    /**
     * Get the createdAt property: Exact time the message was created.
     *
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the updatedAt property: The exact time the message was updated.
     *
     * @return the updatedAt value.
     */
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the userMetadata property: User Metadata is a placeholder to store user-defined string data with maximum
     * length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information
     * also user-defined configuration settings can be stored.
     *
     * @return the userMetadata value.
     */
    public String userMetadata() {
        return this.userMetadata;
    }

    /**
     * Set the userMetadata property: User Metadata is a placeholder to store user-defined string data with maximum
     * length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information
     * also user-defined configuration settings can be stored.
     *
     * @param userMetadata the userMetadata value to set.
     * @return the ConsumerGroupProperties object itself.
     */
    public ConsumerGroupProperties withUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
