/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.fluent.models.ClusterProperties;
import com.azure.resourcemanager.eventhubs.models.ClusterSku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ClusterInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ClusterInner.class);
    @JsonProperty(value="sku")
    private ClusterSku sku;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties")
    private ClusterProperties innerProperties;

    public ClusterSku sku() {
        return this.sku;
    }

    public ClusterInner withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public String updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

