/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventhubs.fluent.ConsumerGroupsClient;
import com.azure.resourcemanager.eventhubs.fluent.DisasterRecoveryConfigsClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubsClient;
import com.azure.resourcemanager.eventhubs.fluent.NamespacesClient;
import com.azure.resourcemanager.eventhubs.fluent.OperationsClient;
import com.azure.resourcemanager.eventhubs.fluent.RegionsClient;
import com.azure.resourcemanager.eventhubs.implementation.ConsumerGroupsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.DisasterRecoveryConfigsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.EventHubsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.OperationsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.RegionsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class EventHubManagementClientImpl
extends AzureServiceClient
implements EventHubManagementClient {
    private final ClientLogger logger = new ClientLogger(EventHubManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final NamespacesClient namespaces;
    private final DisasterRecoveryConfigsClient disasterRecoveryConfigs;
    private final EventHubsClient eventHubs;
    private final ConsumerGroupsClient consumerGroups;
    private final OperationsClient operations;
    private final RegionsClient regions;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public DisasterRecoveryConfigsClient getDisasterRecoveryConfigs() {
        return this.disasterRecoveryConfigs;
    }

    @Override
    public EventHubsClient getEventHubs() {
        return this.eventHubs;
    }

    @Override
    public ConsumerGroupsClient getConsumerGroups() {
        return this.consumerGroups;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public RegionsClient getRegions() {
        return this.regions;
    }

    EventHubManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2017-04-01";
        this.namespaces = new NamespacesClientImpl(this);
        this.disasterRecoveryConfigs = new DisasterRecoveryConfigsClientImpl(this);
        this.eventHubs = new EventHubsClientImpl(this);
        this.consumerGroups = new ConsumerGroupsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.regions = new RegionsClientImpl(this);
    }
}

