// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * The Application Group object.
 */
@Fluent
public final class ApplicationGroupInner extends ProxyResource {
    /*
     * The properties property.
     */
    @JsonProperty(value = "properties")
    private ApplicationGroupProperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * Creates an instance of ApplicationGroupInner class.
     */
    public ApplicationGroupInner() {
    }

    /**
     * Get the innerProperties property: The properties property.
     *
     * @return the innerProperties value.
     */
    private ApplicationGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the isEnabled property: Determines if Application Group is allowed to create connection with namespace or
     * not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no
     * new connections will be allowed.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    /**
     * Set the isEnabled property: Determines if Application Group is allowed to create connection with namespace or
     * not. Once the isEnabled is set to false, all the existing connections of application group gets dropped and no
     * new connections will be allowed.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the ApplicationGroupInner object itself.
     */
    public ApplicationGroupInner withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    /**
     * Get the clientAppGroupIdentifier property: The Unique identifier for application group.Supports
     * SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid).
     *
     * @return the clientAppGroupIdentifier value.
     */
    public String clientAppGroupIdentifier() {
        return this.innerProperties() == null ? null : this.innerProperties().clientAppGroupIdentifier();
    }

    /**
     * Set the clientAppGroupIdentifier property: The Unique identifier for application group.Supports
     * SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid).
     *
     * @param clientAppGroupIdentifier the clientAppGroupIdentifier value to set.
     * @return the ApplicationGroupInner object itself.
     */
    public ApplicationGroupInner withClientAppGroupIdentifier(String clientAppGroupIdentifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withClientAppGroupIdentifier(clientAppGroupIdentifier);
        return this;
    }

    /**
     * Get the policies property: List of group policies that define the behavior of application group. The policies can
     * support resource governance scenarios such as limiting ingress or egress traffic.
     *
     * @return the policies value.
     */
    public List<ApplicationGroupPolicy> policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    /**
     * Set the policies property: List of group policies that define the behavior of application group. The policies can
     * support resource governance scenarios such as limiting ingress or egress traffic.
     *
     * @param policies the policies value to set.
     * @return the ApplicationGroupInner object itself.
     */
    public ApplicationGroupInner withPolicies(List<ApplicationGroupPolicy> policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGroupProperties();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
