// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.eventhubs.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Event Hubs Cluster properties supplied in responses in List or Get operations.
 */
@Fluent
public final class ClusterProperties {
    /*
     * The UTC time when the Event Hubs Cluster was created.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private String createdAt;

    /*
     * Provisioning state of the Cluster.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The UTC time when the Event Hubs Cluster was last updated.
     */
    @JsonProperty(value = "updatedAt", access = JsonProperty.Access.WRITE_ONLY)
    private String updatedAt;

    /*
     * The metric ID of the cluster resource. Provided by the service and not modifiable by the user.
     */
    @JsonProperty(value = "metricId", access = JsonProperty.Access.WRITE_ONLY)
    private String metricId;

    /*
     * Status of the Cluster resource
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /*
     * A value that indicates whether Scaling is Supported.
     */
    @JsonProperty(value = "supportsScaling")
    private Boolean supportsScaling;

    /**
     * Creates an instance of ClusterProperties class.
     */
    public ClusterProperties() {
    }

    /**
     * Get the createdAt property: The UTC time when the Event Hubs Cluster was created.
     * 
     * @return the createdAt value.
     */
    public String createdAt() {
        return this.createdAt;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Cluster.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the updatedAt property: The UTC time when the Event Hubs Cluster was last updated.
     * 
     * @return the updatedAt value.
     */
    public String updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the metricId property: The metric ID of the cluster resource. Provided by the service and not modifiable by
     * the user.
     * 
     * @return the metricId value.
     */
    public String metricId() {
        return this.metricId;
    }

    /**
     * Get the status property: Status of the Cluster resource.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Get the supportsScaling property: A value that indicates whether Scaling is Supported.
     * 
     * @return the supportsScaling value.
     */
    public Boolean supportsScaling() {
        return this.supportsScaling;
    }

    /**
     * Set the supportsScaling property: A value that indicates whether Scaling is Supported.
     * 
     * @param supportsScaling the supportsScaling value to set.
     * @return the ClusterProperties object itself.
     */
    public ClusterProperties withSupportsScaling(Boolean supportsScaling) {
        this.supportsScaling = supportsScaling;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
