// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.eventhubs.models.SchemaCompatibility;
import com.azure.resourcemanager.eventhubs.models.SchemaType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

/**
 * The SchemaGroupProperties model.
 */
@Fluent
public final class SchemaGroupProperties {
    /*
     * Exact time the Schema Group was updated
     */
    @JsonProperty(value = "updatedAtUtc", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAtUtc;

    /*
     * Exact time the Schema Group was created.
     */
    @JsonProperty(value = "createdAtUtc", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAtUtc;

    /*
     * The ETag value.
     */
    @JsonProperty(value = "eTag", access = JsonProperty.Access.WRITE_ONLY)
    private UUID etag;

    /*
     * dictionary object for SchemaGroup group properties
     */
    @JsonProperty(value = "groupProperties")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> groupProperties;

    /*
     * The schemaCompatibility property.
     */
    @JsonProperty(value = "schemaCompatibility")
    private SchemaCompatibility schemaCompatibility;

    /*
     * The schemaType property.
     */
    @JsonProperty(value = "schemaType")
    private SchemaType schemaType;

    /**
     * Creates an instance of SchemaGroupProperties class.
     */
    public SchemaGroupProperties() {
    }

    /**
     * Get the updatedAtUtc property: Exact time the Schema Group was updated.
     *
     * @return the updatedAtUtc value.
     */
    public OffsetDateTime updatedAtUtc() {
        return this.updatedAtUtc;
    }

    /**
     * Get the createdAtUtc property: Exact time the Schema Group was created.
     *
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    /**
     * Get the etag property: The ETag value.
     *
     * @return the etag value.
     */
    public UUID etag() {
        return this.etag;
    }

    /**
     * Get the groupProperties property: dictionary object for SchemaGroup group properties.
     *
     * @return the groupProperties value.
     */
    public Map<String, String> groupProperties() {
        return this.groupProperties;
    }

    /**
     * Set the groupProperties property: dictionary object for SchemaGroup group properties.
     *
     * @param groupProperties the groupProperties value to set.
     * @return the SchemaGroupProperties object itself.
     */
    public SchemaGroupProperties withGroupProperties(Map<String, String> groupProperties) {
        this.groupProperties = groupProperties;
        return this;
    }

    /**
     * Get the schemaCompatibility property: The schemaCompatibility property.
     *
     * @return the schemaCompatibility value.
     */
    public SchemaCompatibility schemaCompatibility() {
        return this.schemaCompatibility;
    }

    /**
     * Set the schemaCompatibility property: The schemaCompatibility property.
     *
     * @param schemaCompatibility the schemaCompatibility value to set.
     * @return the SchemaGroupProperties object itself.
     */
    public SchemaGroupProperties withSchemaCompatibility(SchemaCompatibility schemaCompatibility) {
        this.schemaCompatibility = schemaCompatibility;
        return this;
    }

    /**
     * Get the schemaType property: The schemaType property.
     *
     * @return the schemaType value.
     */
    public SchemaType schemaType() {
        return this.schemaType;
    }

    /**
     * Set the schemaType property: The schemaType property.
     *
     * @param schemaType the schemaType value to set.
     * @return the SchemaGroupProperties object itself.
     */
    public SchemaGroupProperties withSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
