// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameter supplied to check Namespace name availability operation.
 */
@Fluent
public final class CheckNameAvailabilityParameter {
    /*
     * Name to check the namespace name availability
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * Creates an instance of CheckNameAvailabilityParameter class.
     */
    public CheckNameAvailabilityParameter() {
    }

    /**
     * Get the name property: Name to check the namespace name availability.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name to check the namespace name availability.
     * 
     * @param name the name value to set.
     * @return the CheckNameAvailabilityParameter object itself.
     */
    public CheckNameAvailabilityParameter withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model CheckNameAvailabilityParameter"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailabilityParameter.class);
}
