// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Properties of Access Rule.
 */
@Fluent
public final class NspAccessRuleProperties {
    /*
     * Direction of Access Rule
     */
    @JsonProperty(value = "direction")
    private NspAccessRuleDirection direction;

    /*
     * Address prefixes in the CIDR format for inbound rules
     */
    @JsonProperty(value = "addressPrefixes")
    private List<String> addressPrefixes;

    /*
     * Subscriptions for inbound rules
     */
    @JsonProperty(value = "subscriptions")
    private List<NspAccessRulePropertiesSubscriptionsItem> subscriptions;

    /*
     * NetworkSecurityPerimeters for inbound rules
     */
    @JsonProperty(value = "networkSecurityPerimeters", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkSecurityPerimeter> networkSecurityPerimeters;

    /*
     * FQDN for outbound rules
     */
    @JsonProperty(value = "fullyQualifiedDomainNames", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> fullyQualifiedDomainNames;

    /**
     * Creates an instance of NspAccessRuleProperties class.
     */
    public NspAccessRuleProperties() {
    }

    /**
     * Get the direction property: Direction of Access Rule.
     *
     * @return the direction value.
     */
    public NspAccessRuleDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: Direction of Access Rule.
     *
     * @param direction the direction value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withDirection(NspAccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the addressPrefixes property: Address prefixes in the CIDR format for inbound rules.
     *
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: Address prefixes in the CIDR format for inbound rules.
     *
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the subscriptions property: Subscriptions for inbound rules.
     *
     * @return the subscriptions value.
     */
    public List<NspAccessRulePropertiesSubscriptionsItem> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: Subscriptions for inbound rules.
     *
     * @param subscriptions the subscriptions value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withSubscriptions(List<NspAccessRulePropertiesSubscriptionsItem> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the networkSecurityPerimeters property: NetworkSecurityPerimeters for inbound rules.
     *
     * @return the networkSecurityPerimeters value.
     */
    public List<NetworkSecurityPerimeter> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    /**
     * Get the fullyQualifiedDomainNames property: FQDN for outbound rules.
     *
     * @return the fullyQualifiedDomainNames value.
     */
    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subscriptions() != null) {
            subscriptions().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeters() != null) {
            networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }
}
