// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of Provisioning Issue.
 */
@Fluent
public final class ProvisioningIssueProperties {
    /*
     * Type of Issue
     */
    @JsonProperty(value = "issueType")
    private String issueType;

    /*
     * Description of the issue
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * Creates an instance of ProvisioningIssueProperties class.
     */
    public ProvisioningIssueProperties() {
    }

    /**
     * Get the issueType property: Type of Issue.
     * 
     * @return the issueType value.
     */
    public String issueType() {
        return this.issueType;
    }

    /**
     * Set the issueType property: Type of Issue.
     * 
     * @param issueType the issueType value to set.
     * @return the ProvisioningIssueProperties object itself.
     */
    public ProvisioningIssueProperties withIssueType(String issueType) {
        this.issueType = issueType;
        return this;
    }

    /**
     * Get the description property: Description of the issue.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the issue.
     * 
     * @param description the description value to set.
     * @return the ProvisioningIssueProperties object itself.
     */
    public ProvisioningIssueProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
