/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.eventhubs.models.NspAccessRuleDirection;
import com.azure.resourcemanager.eventhubs.models.NspAccessRulePropertiesSubscriptionsItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NspAccessRuleProperties {
    @JsonProperty(value="direction")
    private NspAccessRuleDirection direction;
    @JsonProperty(value="addressPrefixes")
    private List<String> addressPrefixes;
    @JsonProperty(value="subscriptions")
    private List<NspAccessRulePropertiesSubscriptionsItem> subscriptions;
    @JsonProperty(value="networkSecurityPerimeters", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkSecurityPerimeter> networkSecurityPerimeters;
    @JsonProperty(value="fullyQualifiedDomainNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> fullyQualifiedDomainNames;

    public NspAccessRuleDirection direction() {
        return this.direction;
    }

    public NspAccessRuleProperties withDirection(NspAccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public NspAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<NspAccessRulePropertiesSubscriptionsItem> subscriptions() {
        return this.subscriptions;
    }

    public NspAccessRuleProperties withSubscriptions(List<NspAccessRulePropertiesSubscriptionsItem> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<NetworkSecurityPerimeter> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeters() != null) {
            this.networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }
}

