/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.NetworkSecurityPerimeterConfigurationProperties;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.eventhubs.models.ProvisioningIssue;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfiguration
extends ProxyResource {
    private NetworkSecurityPerimeterConfigurationProperties innerProperties;
    private String location;
    private String id;
    private String name;
    private String type;

    private NetworkSecurityPerimeterConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NetworkSecurityPerimeterConfiguration withProvisioningState(NetworkSecurityPerimeterConfigurationProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public List<ProvisioningIssue> provisioningIssues() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningIssues();
    }

    public NetworkSecurityPerimeterConfiguration withProvisioningIssues(List<ProvisioningIssue> provisioningIssues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkSecurityPerimeterConfigurationProperties();
        }
        this.innerProperties().withProvisioningIssues(provisioningIssues);
        return this;
    }

    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityPerimeter();
    }

    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceAssociation();
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.innerProperties() == null ? null : this.innerProperties().profile();
    }

    public Boolean isBackingResource() {
        return this.innerProperties() == null ? null : this.innerProperties().isBackingResource();
    }

    public List<String> applicableFeatures() {
        return this.innerProperties() == null ? null : this.innerProperties().applicableFeatures();
    }

    public String parentAssociationName() {
        return this.innerProperties() == null ? null : this.innerProperties().parentAssociationName();
    }

    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfiguration)((Object)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfiguration deserializedNetworkSecurityPerimeterConfiguration = new NetworkSecurityPerimeterConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.innerProperties = NetworkSecurityPerimeterConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfiguration.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfiguration;
        }));
    }
}

