// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfiguration;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List NetworkSecurityPerimeterConfiguration operation.
 */
@Immutable
public final class NetworkSecurityPerimeterConfigurationListInner
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationListInner> {
    /*
     * A collection of NetworkSecurityPerimeterConfigurations
     */
    private List<NetworkSecurityPerimeterConfiguration> value;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationListInner class.
     */
    public NetworkSecurityPerimeterConfigurationListInner() {
    }

    /**
     * Get the value property: A collection of NetworkSecurityPerimeterConfigurations.
     * 
     * @return the value value.
     */
    public List<NetworkSecurityPerimeterConfiguration> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationListInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationListInner.
     */
    public static NetworkSecurityPerimeterConfigurationListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationListInner deserializedNetworkSecurityPerimeterConfigurationListInner
                = new NetworkSecurityPerimeterConfigurationListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NetworkSecurityPerimeterConfiguration> value
                        = reader.readArray(reader1 -> NetworkSecurityPerimeterConfiguration.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationListInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationListInner;
        });
    }
}
