// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ConnectionState information.
 */
@Fluent
public final class ConnectionState implements JsonSerializable<ConnectionState> {
    /*
     * Status of the connection.
     */
    private PrivateLinkConnectionStatus status;

    /*
     * Description of the connection state.
     */
    private String description;

    /**
     * Creates an instance of ConnectionState class.
     */
    public ConnectionState() {
    }

    /**
     * Get the status property: Status of the connection.
     * 
     * @return the status value.
     */
    public PrivateLinkConnectionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the connection.
     * 
     * @param status the status value to set.
     * @return the ConnectionState object itself.
     */
    public ConnectionState withStatus(PrivateLinkConnectionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description property: Description of the connection state.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the connection state.
     * 
     * @param description the description value to set.
     * @return the ConnectionState object itself.
     */
    public ConnectionState withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionState if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionState.
     */
    public static ConnectionState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionState deserializedConnectionState = new ConnectionState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedConnectionState.status = PrivateLinkConnectionStatus.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedConnectionState.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionState;
        });
    }
}
