/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventhubs.models.Encryption;
import com.azure.resourcemanager.eventhubs.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventhubs.models.TlsVersion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class EHNamespaceProperties
implements JsonSerializable<EHNamespaceProperties> {
    private TlsVersion minimumTlsVersion;
    private String provisioningState;
    private String status;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private String serviceBusEndpoint;
    private String clusterArmId;
    private String metricId;
    private Boolean isAutoInflateEnabled;
    private PublicNetworkAccess publicNetworkAccess;
    private Integer maximumThroughputUnits;
    private Boolean kafkaEnabled;
    private Boolean zoneRedundant;
    private Encryption encryption;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean disableLocalAuth;
    private String alternateName;

    public TlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public EHNamespaceProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public String clusterArmId() {
        return this.clusterArmId;
    }

    public EHNamespaceProperties withClusterArmId(String clusterArmId) {
        this.clusterArmId = clusterArmId;
        return this;
    }

    public String metricId() {
        return this.metricId;
    }

    public Boolean isAutoInflateEnabled() {
        return this.isAutoInflateEnabled;
    }

    public EHNamespaceProperties withIsAutoInflateEnabled(Boolean isAutoInflateEnabled) {
        this.isAutoInflateEnabled = isAutoInflateEnabled;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public EHNamespaceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Integer maximumThroughputUnits() {
        return this.maximumThroughputUnits;
    }

    public EHNamespaceProperties withMaximumThroughputUnits(Integer maximumThroughputUnits) {
        this.maximumThroughputUnits = maximumThroughputUnits;
        return this;
    }

    public Boolean kafkaEnabled() {
        return this.kafkaEnabled;
    }

    public EHNamespaceProperties withKafkaEnabled(Boolean kafkaEnabled) {
        this.kafkaEnabled = kafkaEnabled;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public EHNamespaceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public EHNamespaceProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public EHNamespaceProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public EHNamespaceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String alternateName() {
        return this.alternateName;
    }

    public EHNamespaceProperties withAlternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeStringField("clusterArmId", this.clusterArmId);
        jsonWriter.writeBooleanField("isAutoInflateEnabled", this.isAutoInflateEnabled);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeNumberField("maximumThroughputUnits", (Number)this.maximumThroughputUnits);
        jsonWriter.writeBooleanField("kafkaEnabled", this.kafkaEnabled);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("alternateName", this.alternateName);
        return jsonWriter.writeEndObject();
    }

    public static EHNamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EHNamespaceProperties)jsonReader.readObject(reader -> {
            EHNamespaceProperties deserializedEHNamespaceProperties = new EHNamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedEHNamespaceProperties.minimumTlsVersion = TlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEHNamespaceProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEHNamespaceProperties.status = reader.getString();
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedEHNamespaceProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedEHNamespaceProperties.updatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("serviceBusEndpoint".equals(fieldName)) {
                    deserializedEHNamespaceProperties.serviceBusEndpoint = reader.getString();
                    continue;
                }
                if ("clusterArmId".equals(fieldName)) {
                    deserializedEHNamespaceProperties.clusterArmId = reader.getString();
                    continue;
                }
                if ("metricId".equals(fieldName)) {
                    deserializedEHNamespaceProperties.metricId = reader.getString();
                    continue;
                }
                if ("isAutoInflateEnabled".equals(fieldName)) {
                    deserializedEHNamespaceProperties.isAutoInflateEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedEHNamespaceProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("maximumThroughputUnits".equals(fieldName)) {
                    deserializedEHNamespaceProperties.maximumThroughputUnits = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("kafkaEnabled".equals(fieldName)) {
                    deserializedEHNamespaceProperties.kafkaEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedEHNamespaceProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedEHNamespaceProperties.encryption = Encryption.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedEHNamespaceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedEHNamespaceProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("alternateName".equals(fieldName)) {
                    deserializedEHNamespaceProperties.alternateName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEHNamespaceProperties;
        });
    }
}

