// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.AccessRights;
import java.io.IOException;
import java.util.List;

/**
 * Properties supplied to create or update AuthorizationRule.
 */
@Fluent
public final class AuthorizationRuleProperties implements JsonSerializable<AuthorizationRuleProperties> {
    /*
     * The rights associated with the rule.
     */
    private List<AccessRights> rights;

    /**
     * Creates an instance of AuthorizationRuleProperties class.
     */
    public AuthorizationRuleProperties() {
    }

    /**
     * Get the rights property: The rights associated with the rule.
     * 
     * @return the rights value.
     */
    public List<AccessRights> rights() {
        return this.rights;
    }

    /**
     * Set the rights property: The rights associated with the rule.
     * 
     * @param rights the rights value to set.
     * @return the AuthorizationRuleProperties object itself.
     */
    public AuthorizationRuleProperties withRights(List<AccessRights> rights) {
        this.rights = rights;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rights() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property rights in model AuthorizationRuleProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationRuleProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rights", this.rights,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationRuleProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AuthorizationRuleProperties.
     */
    public static AuthorizationRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationRuleProperties deserializedAuthorizationRuleProperties = new AuthorizationRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rights".equals(fieldName)) {
                    List<AccessRights> rights
                        = reader.readArray(reader1 -> AccessRights.fromString(reader1.getString()));
                    deserializedAuthorizationRuleProperties.rights = rights;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationRuleProperties;
        });
    }
}
