// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.ClusterSku;
import com.azure.resourcemanager.eventhubs.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

/**
 * Single Event Hubs Cluster resource in List or Get operations.
 */
@Fluent
public final class ClusterInner extends Resource {
    /*
     * Properties of the cluster SKU.
     */
    private ClusterSku sku;

    /*
     * The system meta data relating to this resource.
     */
    private SystemData systemData;

    /*
     * Event Hubs Cluster properties supplied in responses in List or Get operations.
     */
    private ClusterProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ClusterInner class.
     */
    public ClusterInner() {
    }

    /**
     * Get the sku property: Properties of the cluster SKU.
     * 
     * @return the sku value.
     */
    public ClusterSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Properties of the cluster SKU.
     * 
     * @param sku the sku value to set.
     * @return the ClusterInner object itself.
     */
    public ClusterInner withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the innerProperties property: Event Hubs Cluster properties supplied in responses in List or Get operations.
     * 
     * @return the innerProperties value.
     */
    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the createdAt property: The UTC time when the Event Hubs Cluster was created.
     * 
     * @return the createdAt value.
     */
    public String createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    /**
     * Get the provisioningState property: Provisioning state of the Cluster.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the updatedAt property: The UTC time when the Event Hubs Cluster was last updated.
     * 
     * @return the updatedAt value.
     */
    public String updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    /**
     * Get the metricId property: The metric ID of the cluster resource. Provided by the service and not modifiable by
     * the user.
     * 
     * @return the metricId value.
     */
    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    /**
     * Get the status property: Status of the Cluster resource.
     * 
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the supportsScaling property: A value that indicates whether Scaling is Supported.
     * 
     * @return the supportsScaling value.
     */
    public Boolean supportsScaling() {
        return this.innerProperties() == null ? null : this.innerProperties().supportsScaling();
    }

    /**
     * Set the supportsScaling property: A value that indicates whether Scaling is Supported.
     * 
     * @param supportsScaling the supportsScaling value to set.
     * @return the ClusterInner object itself.
     */
    public ClusterInner withSupportsScaling(Boolean supportsScaling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withSupportsScaling(supportsScaling);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ClusterInner.
     */
    public static ClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterInner deserializedClusterInner = new ClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedClusterInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedClusterInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedClusterInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedClusterInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedClusterInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedClusterInner.sku = ClusterSku.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedClusterInner.systemData = SystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedClusterInner.innerProperties = ClusterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterInner;
        });
    }
}
