// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Single item in List or Get Consumer group operation.
 */
@Fluent
public final class ConsumerGroupProperties implements JsonSerializable<ConsumerGroupProperties> {
    /*
     * Exact time the message was created.
     */
    private OffsetDateTime createdAt;

    /*
     * The exact time the message was updated.
     */
    private OffsetDateTime updatedAt;

    /*
     * User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to
     * store descriptive data, such as list of teams and their contact information also user-defined configuration
     * settings can be stored.
     */
    private String userMetadata;

    /**
     * Creates an instance of ConsumerGroupProperties class.
     */
    public ConsumerGroupProperties() {
    }

    /**
     * Get the createdAt property: Exact time the message was created.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Get the updatedAt property: The exact time the message was updated.
     * 
     * @return the updatedAt value.
     */
    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    /**
     * Get the userMetadata property: User Metadata is a placeholder to store user-defined string data with maximum
     * length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information
     * also user-defined configuration settings can be stored.
     * 
     * @return the userMetadata value.
     */
    public String userMetadata() {
        return this.userMetadata;
    }

    /**
     * Set the userMetadata property: User Metadata is a placeholder to store user-defined string data with maximum
     * length 1024. e.g. it can be used to store descriptive data, such as list of teams and their contact information
     * also user-defined configuration settings can be stored.
     * 
     * @param userMetadata the userMetadata value to set.
     * @return the ConsumerGroupProperties object itself.
     */
    public ConsumerGroupProperties withUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userMetadata", this.userMetadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConsumerGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConsumerGroupProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConsumerGroupProperties.
     */
    public static ConsumerGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConsumerGroupProperties deserializedConsumerGroupProperties = new ConsumerGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdAt".equals(fieldName)) {
                    deserializedConsumerGroupProperties.createdAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updatedAt".equals(fieldName)) {
                    deserializedConsumerGroupProperties.updatedAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("userMetadata".equals(fieldName)) {
                    deserializedConsumerGroupProperties.userMetadata = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConsumerGroupProperties;
        });
    }
}
