// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * Properties describing the storage account, blob container and archive name format for capture destination.
 */
@Fluent
public final class DestinationProperties implements JsonSerializable<DestinationProperties> {
    /*
     * Resource id of the storage account to be used to create the blobs
     */
    private String storageAccountResourceId;

    /*
     * Blob container Name
     */
    private String blobContainer;

    /*
     * Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters
     * (Namespace,EventHub .. etc) are mandatory irrespective of order
     */
    private String archiveNameFormat;

    /*
     * Subscription Id of Azure Data Lake Store
     */
    private UUID dataLakeSubscriptionId;

    /*
     * The Azure Data Lake Store name for the captured events
     */
    private String dataLakeAccountName;

    /*
     * The destination folder path for the captured events
     */
    private String dataLakeFolderPath;

    /**
     * Creates an instance of DestinationProperties class.
     */
    public DestinationProperties() {
    }

    /**
     * Get the storageAccountResourceId property: Resource id of the storage account to be used to create the blobs.
     * 
     * @return the storageAccountResourceId value.
     */
    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    /**
     * Set the storageAccountResourceId property: Resource id of the storage account to be used to create the blobs.
     * 
     * @param storageAccountResourceId the storageAccountResourceId value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    /**
     * Get the blobContainer property: Blob container Name.
     * 
     * @return the blobContainer value.
     */
    public String blobContainer() {
        return this.blobContainer;
    }

    /**
     * Set the blobContainer property: Blob container Name.
     * 
     * @param blobContainer the blobContainer value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withBlobContainer(String blobContainer) {
        this.blobContainer = blobContainer;
        return this;
    }

    /**
     * Get the archiveNameFormat property: Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters
     * (Namespace,EventHub .. etc) are mandatory irrespective of order.
     * 
     * @return the archiveNameFormat value.
     */
    public String archiveNameFormat() {
        return this.archiveNameFormat;
    }

    /**
     * Set the archiveNameFormat property: Blob naming convention for archive, e.g.
     * {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all the parameters
     * (Namespace,EventHub .. etc) are mandatory irrespective of order.
     * 
     * @param archiveNameFormat the archiveNameFormat value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withArchiveNameFormat(String archiveNameFormat) {
        this.archiveNameFormat = archiveNameFormat;
        return this;
    }

    /**
     * Get the dataLakeSubscriptionId property: Subscription Id of Azure Data Lake Store.
     * 
     * @return the dataLakeSubscriptionId value.
     */
    public UUID dataLakeSubscriptionId() {
        return this.dataLakeSubscriptionId;
    }

    /**
     * Set the dataLakeSubscriptionId property: Subscription Id of Azure Data Lake Store.
     * 
     * @param dataLakeSubscriptionId the dataLakeSubscriptionId value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeSubscriptionId(UUID dataLakeSubscriptionId) {
        this.dataLakeSubscriptionId = dataLakeSubscriptionId;
        return this;
    }

    /**
     * Get the dataLakeAccountName property: The Azure Data Lake Store name for the captured events.
     * 
     * @return the dataLakeAccountName value.
     */
    public String dataLakeAccountName() {
        return this.dataLakeAccountName;
    }

    /**
     * Set the dataLakeAccountName property: The Azure Data Lake Store name for the captured events.
     * 
     * @param dataLakeAccountName the dataLakeAccountName value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeAccountName(String dataLakeAccountName) {
        this.dataLakeAccountName = dataLakeAccountName;
        return this;
    }

    /**
     * Get the dataLakeFolderPath property: The destination folder path for the captured events.
     * 
     * @return the dataLakeFolderPath value.
     */
    public String dataLakeFolderPath() {
        return this.dataLakeFolderPath;
    }

    /**
     * Set the dataLakeFolderPath property: The destination folder path for the captured events.
     * 
     * @param dataLakeFolderPath the dataLakeFolderPath value to set.
     * @return the DestinationProperties object itself.
     */
    public DestinationProperties withDataLakeFolderPath(String dataLakeFolderPath) {
        this.dataLakeFolderPath = dataLakeFolderPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountResourceId", this.storageAccountResourceId);
        jsonWriter.writeStringField("blobContainer", this.blobContainer);
        jsonWriter.writeStringField("archiveNameFormat", this.archiveNameFormat);
        jsonWriter.writeStringField("dataLakeSubscriptionId", Objects.toString(this.dataLakeSubscriptionId, null));
        jsonWriter.writeStringField("dataLakeAccountName", this.dataLakeAccountName);
        jsonWriter.writeStringField("dataLakeFolderPath", this.dataLakeFolderPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DestinationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DestinationProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DestinationProperties.
     */
    public static DestinationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DestinationProperties deserializedDestinationProperties = new DestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountResourceId".equals(fieldName)) {
                    deserializedDestinationProperties.storageAccountResourceId = reader.getString();
                } else if ("blobContainer".equals(fieldName)) {
                    deserializedDestinationProperties.blobContainer = reader.getString();
                } else if ("archiveNameFormat".equals(fieldName)) {
                    deserializedDestinationProperties.archiveNameFormat = reader.getString();
                } else if ("dataLakeSubscriptionId".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeSubscriptionId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("dataLakeAccountName".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeAccountName = reader.getString();
                } else if ("dataLakeFolderPath".equals(fieldName)) {
                    deserializedDestinationProperties.dataLakeFolderPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDestinationProperties;
        });
    }
}
