// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.AvailableCluster;
import java.io.IOException;
import java.util.List;

/**
 * The response of the List Available Clusters operation.
 */
@Fluent
public final class AvailableClustersListInner implements JsonSerializable<AvailableClustersListInner> {
    /*
     * The count of readily available and pre-provisioned Event Hubs Clusters per region.
     */
    private List<AvailableCluster> value;

    /**
     * Creates an instance of AvailableClustersListInner class.
     */
    public AvailableClustersListInner() {
    }

    /**
     * Get the value property: The count of readily available and pre-provisioned Event Hubs Clusters per region.
     * 
     * @return the value value.
     */
    public List<AvailableCluster> value() {
        return this.value;
    }

    /**
     * Set the value property: The count of readily available and pre-provisioned Event Hubs Clusters per region.
     * 
     * @param value the value value to set.
     * @return the AvailableClustersListInner object itself.
     */
    public AvailableClustersListInner withValue(List<AvailableCluster> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableClustersListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableClustersListInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailableClustersListInner.
     */
    public static AvailableClustersListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableClustersListInner deserializedAvailableClustersListInner = new AvailableClustersListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AvailableCluster> value = reader.readArray(reader1 -> AvailableCluster.fromJson(reader1));
                    deserializedAvailableClustersListInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableClustersListInner;
        });
    }
}
