/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleProperties;
import com.azure.resourcemanager.eventhubs.models.AccessRights;
import java.io.IOException;
import java.util.List;

public final class AuthorizationRuleInner
extends ProxyResource {
    private AuthorizationRuleProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String id;
    private String name;
    private String type;

    private AuthorizationRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public List<AccessRights> rights() {
        return this.innerProperties() == null ? null : this.innerProperties().rights();
    }

    public AuthorizationRuleInner withRights(List<AccessRights> rights) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AuthorizationRuleProperties();
        }
        this.innerProperties().withRights(rights);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationRuleInner)((Object)jsonReader.readObject(reader -> {
            AuthorizationRuleInner deserializedAuthorizationRuleInner = new AuthorizationRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.innerProperties = AuthorizationRuleProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAuthorizationRuleInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationRuleInner;
        }));
    }
}

