/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventhubs.fluent.RegionsClient;
import com.azure.resourcemanager.eventhubs.fluent.models.MessagingRegionsInner;
import com.azure.resourcemanager.eventhubs.implementation.EventHubManagementClientImpl;
import com.azure.resourcemanager.eventhubs.models.MessagingRegionsListResult;
import reactor.core.publisher.Mono;

public final class RegionsClientImpl
implements RegionsClient {
    private final ClientLogger logger = new ClientLogger(RegionsClientImpl.class);
    private final RegionsService service;
    private final EventHubManagementClientImpl client;

    RegionsClientImpl(EventHubManagementClientImpl client) {
        this.service = (RegionsService)RestProxy.create(RegionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MessagingRegionsInner>> listBySkuSinglePageAsync(String sku) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySku(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), sku, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MessagingRegionsListResult)res.getValue()).value(), ((MessagingRegionsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MessagingRegionsInner>> listBySkuSinglePageAsync(String sku, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (sku == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sku is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBySku(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), sku, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MessagingRegionsListResult)res.getValue()).value(), ((MessagingRegionsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MessagingRegionsInner> listBySkuAsync(String sku) {
        return new PagedFlux(() -> this.listBySkuSinglePageAsync(sku), nextLink -> this.listBySkuNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MessagingRegionsInner> listBySkuAsync(String sku, Context context) {
        return new PagedFlux(() -> this.listBySkuSinglePageAsync(sku, context), nextLink -> this.listBySkuNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MessagingRegionsInner> listBySku(String sku) {
        return new PagedIterable(this.listBySkuAsync(sku));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MessagingRegionsInner> listBySku(String sku, Context context) {
        return new PagedIterable(this.listBySkuAsync(sku, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MessagingRegionsInner>> listBySkuNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySkuNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MessagingRegionsListResult)res.getValue()).value(), ((MessagingRegionsListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MessagingRegionsInner>> listBySkuNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBySkuNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MessagingRegionsListResult)res.getValue()).value(), ((MessagingRegionsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="EventHubManagementCl")
    private static interface RegionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.EventHub/sku/{sku}/regions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MessagingRegionsListResult>> listBySku(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="sku") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MessagingRegionsListResult>> listBySkuNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

