// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.CheckNameAvailabilityOutputInner;
import com.azure.resourcemanager.frontdoor.models.CheckNameAvailabilityInput;

/** An instance of this class provides access to all the operations defined in FrontDoorNameAvailabilitiesClient. */
public interface FrontDoorNameAvailabilitiesClient {
    /**
     * Check the availability of a Front Door resource name.
     *
     * @param checkFrontDoorNameAvailabilityInput Input to check.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckNameAvailabilityOutputInner> checkWithResponse(
        CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput, Context context);

    /**
     * Check the availability of a Front Door resource name.
     *
     * @param checkFrontDoorNameAvailabilityInput Input to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckNameAvailabilityOutputInner check(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput);
}
